/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.shapes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import dev.gigaherz.jsonthings.things.shapes.IShapeProvider;
import dev.gigaherz.jsonthings.util.CodecExtras;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConditionalShape
implements IShapeProvider {
    public static final Codec<List<Pair<String, Set<String>>>> CONDITION_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CodecExtras.maybeList(Codec.STRING)).xmap(fromMap -> fromMap.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)Sets.newHashSet((Iterable)((Iterable)entry.getValue())))).collect(Collectors.toList()), toMap -> toMap.stream().collect(Collectors.toMap(Pair::getFirst, entry -> Lists.newArrayList((Iterable)((Iterable)entry.getSecond())), (a, b) -> b)));
    public static final Codec<ConditionalShape> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecExtras.maybeList(CONDITION_CODEC).fieldOf("when").forGetter(shape -> shape.conditions), (App)CodecExtras.lazy(DynamicShape::shapeCodec).fieldOf("shape").forGetter(shape -> shape.shape)).apply((Applicative)instance, ConditionalShape::new));
    public final List<List<Pair<String, Set<String>>>> conditions = Lists.newArrayList();
    public final IShapeProvider shape;

    public ConditionalShape(List<List<Pair<String, Set<String>>>> conditions, IShapeProvider shape) {
        this.conditions.addAll(conditions);
        this.shape = shape;
    }

    @Override
    public Optional<VoxelShape> getShape(BlockState state, Direction facing) {
        for (List<Pair<String, Set<String>>> condition : this.conditions) {
            boolean allMatch = true;
            for (Pair<String, Set<String>> p : condition) {
                Optional<Property> prop = state.m_61147_().stream().filter(pr -> pr.m_61708_().equals(p.getFirst())).findFirst();
                if (!prop.isPresent()) {
                    throw new IllegalStateException("Property not found " + (String)p.getFirst());
                }
                Property property = prop.get();
                if (((Set)p.getSecond()).contains(this.getPropertyValueByName(state, property))) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) continue;
            return this.shape.getShape(state, facing);
        }
        return Optional.empty();
    }

    private <T extends Comparable<T>> String getPropertyValueByName(BlockState state, Property<T> property) {
        return property.m_6940_(state.m_61143_(property));
    }

    @Override
    public IShapeProvider bake(Function<String, Property<?>> propertyLookup) {
        List<List<Pair<Property<?>, Set<Comparable<?>>>>> baked = this.conditions.stream().map(l -> l.stream().map(p -> this.parsePropertyValueSet(propertyLookup, (Pair<String, Set<String>>)p)).collect(Collectors.toList())).collect(Collectors.toList());
        return new Baked(baked, this.shape.bake(propertyLookup));
    }

    private Pair<Property<?>, Set<Comparable<?>>> parsePropertyValueSet(Function<String, Property<?>> propertyLookup, Pair<String, Set<String>> condition) {
        String pName = (String)condition.getFirst();
        Property<?> prop = propertyLookup.apply(pName);
        if (prop == null) {
            throw new IllegalStateException("Property " + pName + " not declared in the block.");
        }
        Set values = ((Set)condition.getSecond()).stream().map(s -> this.parseValueFromProperty((Property)prop, (String)s)).collect(Collectors.toSet());
        return Pair.of(prop, values);
    }

    private <T extends Comparable<T>> T parseValueFromProperty(Property<T> prop, String s) {
        return (T)((Comparable)prop.m_6215_(s).orElseThrow(() -> new IllegalStateException("Property value " + s + " not valid in property " + prop.m_61708_())));
    }

    public class Baked
    implements IShapeProvider {
        public final List<List<Pair<Property<?>, Set<Comparable<?>>>>> conditions = Lists.newArrayList();
        public final IShapeProvider shape;

        private Baked(List<List<Pair<Property<?>, Set<Comparable<?>>>>> conditions, IShapeProvider shape) {
            this.conditions.addAll(conditions);
            this.shape = shape;
        }

        @Override
        public Optional<VoxelShape> getShape(BlockState state, Direction facing) {
            for (List<Pair<Property<?>, Set<Comparable<?>>>> condition : this.conditions) {
                boolean allMatch = true;
                for (Pair<Property<?>, Set<Comparable<?>>> p : condition) {
                    Property property = (Property)p.getFirst();
                    Set set = (Set)p.getSecond();
                    if (set.contains(state.m_61143_(property))) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                return this.shape.getShape(state, facing);
            }
            return Optional.empty();
        }

        @Override
        public IShapeProvider bake(Function<String, Property<?>> propertyLookup) {
            return ConditionalShape.this.bake(propertyLookup);
        }
    }
}

